/*
 * Decompiled with CFR 0.152.
 */
package xyz.potomac_foods.ODSUpdater;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Scanner;
import org.apache.commons.io.FileUtils;

public class Main {
    public static void main(String[] args) throws IOException {
        File odsApp = new File(System.getProperty("user.dir") + "\\OrderDisplaySystem.jar");
        String currDir = System.getProperty("user.dir");
        if (odsApp.exists()) {
            System.out.println("Found Order Display System!");
            System.out.println("Checking for a valid internet connection...");
            if (Main.isNetAvailable()) {
                System.out.println("Found valid internet connection!");
                System.out.println("Checking for updates");
                URL versionTxt = new URL("https://www.potomac-foods.xyz/ods/downloads/version.txt");
                Scanner vS = new Scanner(versionTxt.openStream());
                String version = vS.nextLine();
                vS.close();
                System.out.println("Current version online: " + version);
                BufferedReader versionReader = new BufferedReader(new FileReader(currDir + "\\version.txt"));
                String versionDL = versionReader.readLine();
                System.out.println("Current version on computer: " + versionDL);
                double offvNum = Double.parseDouble(versionDL.replaceAll("v", ""));
                double onvNum = Double.parseDouble(version.replace("v", ""));
                if (onvNum > offvNum) {
                    System.out.println("Update found!");
                    System.out.println("Downloading Update");
                    URL url2 = new URL("https://www.potomac-foods.xyz/ods/downloads/OrderDisplaySystem.jar");
                    FileUtils.copyURLToFile(url2, odsApp);
                    BufferedWriter writer = new BufferedWriter(new FileWriter(currDir + "\\version.txt", false));
                    writer.write(version);
                    writer.close();
                } else {
                    System.out.println("No updates found");
                }
                System.out.println("Looking for pictures");
                URL picsTxt = new URL("https://www.potomac-foods.xyz/ods/downloads/images.txt");
                Scanner pS = new Scanner(picsTxt.openStream());
                String[] pics = pS.nextLine().split(",");
                pS.close();
                System.out.println("Found " + pics.length + " pictures!");
                System.out.println("Beginning download..");
                for (String pic : pics) {
                    System.out.println("Downloading " + pic);
                    URL picUrl = new URL("https://www.potomac-foods.xyz/ods/downloads/images/" + pic);
                    File currPic = new File(currDir + "\\images\\" + pic);
                    FileUtils.copyURLToFile(picUrl, currPic);
                }
                System.out.println("Done downloading pictures");
            } else {
                System.out.println("No internet connection, running ODS");
            }
            System.out.println("Executing ODS");
            Runtime.getRuntime().exec("java -jar OrderDisplaySystem.jar");
        } else {
            System.out.println("Not running from right directory. Exiting");
        }
    }

    public static boolean isNetAvailable() {
        try {
            URL url = new URL("https://www.potomac-foods.xyz/ods/downloads");
            URLConnection conn = url.openConnection();
            conn.connect();
            conn.getInputStream().close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

